// ==UserScript==
// @name         企信 - - input文字换行
// @namespace    http://tampermonkey.net/
// @version      1.0
// @description  实现指定div内input元素的文字换行和样式调整
// @author       You
// @match        *://*/*
// @grant        none
// ==/UserScript==

(function () {
	'use strict';

	// 处理元素的通用函数
	function processElement(labelFor, elementType, logMessage) {
		const targetLabel = document.querySelector(`label[for="${labelFor}"]`);

		if (targetLabel) {
			const siblingDiv = targetLabel.nextElementSibling;

			if (siblingDiv && siblingDiv.classList.contains('el-form-item__content')) {
				let targetElement;
				if (elementType === 'input') {
					targetElement = siblingDiv.querySelector('input.el-input__inner');
				} else if (elementType === 'textarea') {
					targetElement = siblingDiv.querySelector('textarea.el-textarea__inner');
				}

				if (targetElement) {
					// 创建一个div来替换元素
					const div = document.createElement('div');

					// 设置div的内容
					div.textContent = (targetElement.value || targetElement.placeholder || '').trim();

					// 设置div样式
					div.style.minHeight = '30px';
					div.style.width = '65%';
					div.style.wordBreak = 'break-word';
					div.style.wordWrap = 'break-word';
					div.style.overflowWrap = 'break-word';
					div.style.whiteSpace = 'pre-wrap';
					div.style.lineBreak = 'anywhere';
					div.style.lineHeight = '1.3'; // 减小行距
					div.style.border = 'none'; // 去掉边框
					div.style.borderRadius = targetElement.style.borderRadius || '4px';
					div.style.padding = targetElement.style.padding || '12px 15px';
					div.style.fontSize = targetElement.style.fontSize || '14px';
					div.style.fontFamily = targetElement.style.fontFamily || 'inherit';
					div.style.backgroundColor = '#FBFCFD'; // 设置背景色
					div.style.color = targetElement.style.color || '#606266';
					div.style.boxSizing = 'border-box';
					div.style.display = 'block';
					div.style.textAlign = 'left'; // 文本靠左对齐
					div.style.verticalAlign = 'top'; // 文本靠上对齐
					div.style.marginTop = '0'; // 去掉上方空白间距

					// 如果元素为空或只有placeholder，设置提示文字样式
					if (!targetElement.value && targetElement.placeholder) {
						div.style.color = '#c0c4cc';
						div.textContent = targetElement.placeholder.trim();
					}

					// 替换元素
					targetElement.parentNode.replaceChild(div, targetElement);

					console.log(logMessage);
				} else {
					console.log(`未找到${elementType}元素`);
				}
			} else {
				console.log('未找到同级div元素');
			}
		} else {
			console.log(`未找到label[for="${labelFor}"]元素`);
		}
	}

	// 等待页面加载完成
	function waitForElement() {
		// 处理amountSource的input元素
		processElement('amountSource', 'input', 'Input已替换为div - 通过label[for="amountSource"]定位');

		// 处理purchaseWayInfo的textarea元素
		processElement('purchaseWayInfo', 'textarea', 'Textarea已替换为div - 通过label[for="purchaseWayInfo"]定位');

		// 处理reason的textarea元素
		processElement('reason', 'textarea', 'Textarea已替换为div - 通过label[for="reason"]定位');

		// 处理summary的textarea元素
		processElement('summary', 'textarea', 'Textarea已替换为div - 通过label[for="summary"]定位');

		// 处理remark的textarea元素
		processElement('remark', 'textarea', 'Textarea已替换为div - 通过label[for="remark"]定位');
	}

	// 页面加载完成后执行
	if (document.readyState === 'loading') {
		document.addEventListener('DOMContentLoaded', waitForElement);
	} else {
		waitForElement();
	}

	// 监听DOM变化，以防元素是动态加载的
	const observer = new MutationObserver(function (mutations) {
		mutations.forEach(function (mutation) {
			if (mutation.type === 'childList') {
				waitForElement();
			}
		});
	});

	observer.observe(document.body, {
		childList: true,
		subtree: true
	});

})();